#include "ScnCopyDVD.h"
#include "copythread.h"
#include "scnutilities.h"

string CD_DestFolder;
string CD_DestTitle;
CCopyThread * ct = NULL;

HRESULT CScnCopyDVD::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	Completed = false;

    GetChildById( L"From", &m_from );
    GetChildById( L"To", &m_to );
    GetChildById( L"CurrentFile", &m_curfile );
    GetChildById( L"Sub1Progress", &m_sub1pb );
    GetChildById( L"Sub2Progress", &m_sub2pb );
    GetChildById( L"Stats", &m_stats );
    GetChildById( L"Cancel", &m_cancel );

	m_from.SetText(L"From : dvd:\\");
	m_to.SetText(strtowstr("To: " + CD_DestFolder + CD_DestTitle + "\\").c_str());

	if (ct)
		delete ct;

	ct = new CCopyThread();
	ct->Source = "dvd:\\";
	ct->Dest = CD_DestFolder + CD_DestTitle + "\\";
	//ct->Source = "usb0:\\test\\";
	//ct->Dest = "usb0:\\test2\\";

	BytesLastTick.QuadPart = 0;
	BytesPerSec.QuadPart = 0;

	ct->CreateThread();

	SetTimer(TM_COPYPROGRESS,50);
	SetTimer(TM_COPYSPEED,1000);

	return S_OK;
}

HRESULT CScnCopyDVD::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
	if (hObjPressed == m_cancel)
	{
		ct->Cancel = true;
		bHandled = TRUE;
	}
	return S_OK;
} 

void CScnCopyDVD::DisplayResult(string & result)
{
	result.append(sprintfa("Copied:\n%d of %d files\n",ct->Total_FilesCopied,ct->Total_Files));
	result.append(sprintfa("%0.1fMb of %0.1fMb\n",(float)(ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart)/(1024.0f*1024.0f),(float)(ct->Total_Size.QuadPart)/(1024.0f*1024.0f)));
	result.append("\n\n");
	result.append("Please Note: You will need to restart Freestyle for newly copied games to appear.");
}

HRESULT CScnCopyDVD::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    // which timer is it?
    switch( pTimer->nId )
    {
        case TM_COPYPROGRESS:
			{
				if (ct->Stage == CS_CANCEL)
				{
					KillTimer(TM_COPYPROGRESS);
					Completed = true;
					memset(&overlapped,0,sizeof(overlapped));
					string result = "File Copy has been cancelled\n\n";
					DisplayResult(result);
					XShowMessageBoxUI(0,L"Transfer Cancelled",strtowstr(result).c_str(),1,btnOk,0,XMB_ERRORICON,&mbresult,&overlapped);
					SetTimer(TM_OVERLAPPED,50);

				} else if (ct->Stage == CS_DONE)
				{
					KillTimer(TM_COPYPROGRESS);
					Completed = true;
					memset(&overlapped,0,sizeof(overlapped));
					string result = "File Copy has been completed\n\n";
					DisplayResult(result);
					XShowMessageBoxUI(0,L"Transfer Completed",strtowstr(result).c_str(),1,btnOk,0,XMB_NOICON,&mbresult,&overlapped);
					SetTimer(TM_OVERLAPPED,50);
				}

				LARGE_INTEGER ETA;
				ETA.QuadPart = 0;
				if (BytesPerSec.QuadPart > 0)
				{
					ETA.QuadPart = ct->Total_Size.QuadPart / BytesPerSec.QuadPart;
				}
				int Hours = ETA.QuadPart / 3600;
				ETA.QuadPart = ETA.QuadPart % 3600;
				int Mins = ETA.QuadPart / 60;
				ETA.QuadPart = ETA.QuadPart % 60;
				int Secs = ETA.QuadPart;


				string progess = sprintfa("%d of %d Files, %0.1fMb of %0.1fMb, %0.1fMb/s, ETA %d:%02d:%02d",ct->Total_FilesCopied,ct->Total_Files,(float)(ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart)/(1024.0f*1024.0f),(float)(ct->Total_Size.QuadPart)/(1024.0f*1024.0f),(float)BytesPerSec.QuadPart/(1024.0f*1024.0f),Hours,Mins,Secs);
				m_stats.SetText(strtowstr(progess).c_str());

				if (ct->Stage == CS_CALCSIZE)
				{
					m_curfile.SetText(L"Calculating Size...");
				} else if (ct->Stage == CS_COPYING)
				{
					string curprog = sprintfa("%s, %0.1fMb of %0.1fMb",ct->GetCurFile().c_str(),(float)(ct->File_Prog.QuadPart)/(1024.0f*1024.0f),(float)(ct->File_Size.QuadPart)/(1024.0f*1024.0f));
					m_curfile.SetText(strtowstr(curprog).c_str());
				} else if (ct->Stage == CS_DONE)
				{
					m_curfile.SetText(L"Done");
				}

				m_sub1pb.SetRange(0,ct->Total_Size.QuadPart/1024);
				m_sub1pb.SetValue((ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart)/1024);

				m_sub2pb.SetRange(0,ct->File_Size.QuadPart/1024);
				m_sub2pb.SetValue(ct->File_Prog.QuadPart/1024);
			}
			break;
		case TM_COPYSPEED:
			{
				BytesPerSec.QuadPart = ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart - BytesLastTick.QuadPart;
				BytesLastTick.QuadPart = ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart;
			}
         case TM_OVERLAPPED:
			{
				// message box done
				if (Completed && XHasOverlappedIoCompleted(&overlapped))
				{
					KillTimer(TM_OVERLAPPED);
					CXuiScene::NavigateBack();
				}
			}
	}
    
    return( S_OK );
}
